<div align="center">

# 🌐 DNS & Network Tools
### Professional Network Analysis Suite

[![Next.js](https://img.shields.io/badge/Next.js-15.1-black?style=for-the-badge&logo=next.js&logoColor=white)](https://nextjs.org/)
[![TypeScript](https://img.shields.io/badge/TypeScript-5.0-blue?style=for-the-badge&logo=typescript&logoColor=white)](https://www.typescriptlang.org/)
[![Tailwind CSS](https://img.shields.io/badge/Tailwind_CSS-3.4-38B2AC?style=for-the-badge&logo=tailwind-css&logoColor=white)](https://tailwindcss.com/)
[![React](https://img.shields.io/badge/React-19.0-61DAFB?style=for-the-badge&logo=react&logoColor=black)](https://react.dev/)
[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg?style=for-the-badge)](https://github.com/RaiyanRafid/dnstool/graphs/commit-activity)

<p align="center">
  <br />
  <b>Everything you need to analyze domains, networks, and email infrastructure in one place.</b>
  <br />
  Serverless • Fast • Modern UI
  <br />
  <br />
</p>

</div>

---

## ✨ Features

This application offers a comprehensive suite of tools divided into four powerful modules.

| 📡 DNS Analysis | 🔌 Network Utilities | 🌐 Domain Intelligence | 📧 Email Health |
| :--- | :--- | :--- | :--- |
| • **DNS Lookup**: A/AAAA/MX/etc.<br>• **Propagation**: Global checks<br>• **DNSSEC**: Security validation<br>• **SPF/DMARC**: Auth records<br>• **Reverse DNS**: IP to Hostname | • **Ping**: Latency check<br>• **Trace**: Route analysis<br>• **Port Scanner**: Open ports<br>• **IP Info**: Geo & ASN details | • **WHOIS**: Registration data<br>• **Expiry**: Domain countdown<br>• **SSL Checker**: Cert validity<br>• **Redirects**: HTTP chain check<br>• **Meta Tags**: SEO analysis | • **Email Health**: Overall score<br>• **SMTP**: Server testing<br>• **MX Lookup**: Mail exchange<br>• **DKIM**: Signature verification<br>• **Blacklist**: Spam listing check |

---

## 🛠️ Technology Stack

This project is architected for performance and scalability using modern web technologies.

-   **Framework**: [Next.js 15 (App Router)](https://nextjs.org) - The React Framework for the Web.
-   **Styling**: [Tailwind CSS v4](https://tailwindcss.com) - Utility-first CSS framework.
-   **Language**: [TypeScript](https://www.typescriptlang.org/) - Typed superset of JavaScript.
-   **UI Components**: [Lucide React](https://lucide.dev) & Custom components.
-   **Animation**: `framer-motion` & `react-spring`.
-   **Data Visualization**: `recharts` & `cobe` (for globes).

---

## 📂 Project Structure

A clean and organized codebase structure for easy maintenance.

```plaintext
dnstools/
├── 📂 public/                 # Static assets (images, icons)
├── 📂 src/
│   ├── 📂 app/                # Next.js App Router (Routes & Pages)
│   │   ├── 📂 api/            # Serverless API Endpoints
│   │   ├── 📂 components/     # Page-specific views (e.g., DNS, WHOIS)
│   │   └── 📄 layout.tsx      # Root application layout
│   └── 📂 components/         # Global shared UI components
├── 📄 .env.local              # Environment configuration
└── 📄 next.config.ts          # Framework configuration
```

---

## 🚀 Getting Started

### Prerequisites

Ensure you have the following installed on your system:

-   **Node.js**: v20 LTS or higher recommended.
-   **Package Manager**: `npm`, `yarn`, or `pnpm`.
-   **Git**: For version control.

### 🔑 Environment Configuration

This application relies on external APIs for certain features.

1.  Copy the example environment file:
    ```bash
    cp .env.local .env.production
    ```
2.  Edit `.env.production` and add your API keys:
    ```bash
    # WHOISXML API Key (Required for WHOIS, DNS, etc.)
    WHOISXML_API_KEY=your_api_key_here
    ```

---

## � Deployment Guide

Choose your preferred deployment method below.

<details open>
<summary><h3>☁️ Option 1: Linux VPS (Ubuntu/Debian)</h3></summary>
<br>

A step-by-step guide to deploying on a fresh Linux server using Nginx and PM2.

**1. System Preparation**
```bash
sudo apt update && sudo apt upgrade -y
sudo apt install -y curl git nginx
```

**2. Install Node.js (v20)**
```bash
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
sudo apt install -y nodejs
```

**3. Clone & Config**
```bash
git clone https://github.com/RaiyanRafid/dnstool.git
cd dnstool
npm install
# Setup env
echo "WHOISXML_API_KEY=your_key" > .env.local
```

**4. Build For Production**
```bash
npm run build
```

**5. Start with Process Manager (PM2)**
```bash
sudo npm install -g pm2
pm2 start npm --name "dnstools" -- start
pm2 startup
pm2 save
```

**6. Nginx Reverse Proxy Setup**
Edit config: `sudo nano /etc/nginx/sites-available/dnstools`

```nginx
server {
    listen 80;
    server_name yourdomain.com;

    location / {
        proxy_pass http://localhost:3000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_cache_bypass $http_upgrade;
    }
}
```

**7. Activate & SSL**
```bash
sudo ln -s /etc/nginx/sites-available/dnstools /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl restart nginx

# Install Certbot for SSL
sudo apt install -y certbot python3-certbot-nginx
sudo certbot --nginx -d yourdomain.com
```

</details>

<details>
<summary><h3>🖥️ Option 2: Webuzo / cPanel</h3></summary>
<br>

Deploying Node.js applications on control panels like Webuzo involves a specific workflow.

**Method A: The "Power User" Way (Recommended)**
1.  **SSH Access**: Log in to your user account via SSH.
2.  **Navigation**: Go to `public_html/your-subdomain`.
3.  **Manual Build**: Run `git clone`, `npm install`, and `npm run build` directly in the terminal.
4.  **Process**: Use `pm2` (if available) or the panel's "Node.js Selector" to point to the app startup.

**Method B: Using Webuzo UI**
1.  **Node.js Manager**: Navigate to the Node.js app creator in Webuzo.
2.  **Create App**:
    -   **App Root**: `/home/user/public_html/dnstool`
    -   **App URL**: `dnstool.yourdomain.com`
    -   **Startup File**: `node_modules/next/dist/bin/next`
3.  **Environment**: You typically need to add Environment Variables via the UI (Key: `WHOISXML_API_KEY`, Value: `...`).
4.  **Start**: Click "Start App".

> **⚠️ Note**: Webuzo's "NPM Install" button often fails with complex dependency trees. We strongly recommend running `npm install` and `npm run build` via SSH *before* trying to start it in the UI.

</details>

<details>
<summary><h3>💻 Option 3: Local Development</h3></summary>
<br>

Run the project on your local machine for development or testing.

```bash
# 1. Clone the repository
git clone https://github.com/RaiyanRafid/dnstool.git

# 2. Enter the directory
cd dnstool

# 3. Install dependencies
npm install

# 4. Start the dev server
npm run dev
```

Open [http://localhost:3000](http://localhost:3000) to view it in the browser.

</details>

---

## 🤝 Contribution

Contributions are welcome! If you have suggestions or find bugs, please open an issue or submit a pull request.

1.  Fork the Project.
2.  Create your Feature Branch (`git checkout -b feature/AmazingFeature`).
3.  Commit your Changes (`git commit -m 'Add some AmazingFeature'`).
4.  Push to the Branch (`git push origin feature/AmazingFeature`).
5.  Open a Pull Request.

---

<div align="center">

Made with ❤️ by [Raiyan Rafid](https://github.com/RaiyanRafid)

</div>
