import DKIMClient from "@/components/dkim-tester/DKIMClient";
import { Metadata } from "next";

export const metadata: Metadata = {
    title: "DKIM Record Inspector & Key Validator",
    description: "Retrieve and validate DKIM public keys. Check key length (1024/2048-bit) and selector configuration for email security.",
    keywords: ["dkim record", "dkim lookup", "email security", "domain keys", "dkim validator", "dkim selector", "email authentication"],
};

export default function DKIMPage() {
    return <DKIMClient />;
}
