import DNSSECClient from "@/components/dnssec/DNSSECClient";
import { Metadata } from "next";

export const metadata: Metadata = {
    title: "DNSSEC Validator - Check Chain of Trust",
    description: "Verify your domain's DNSSEC signature chain. Analyze DS, DNSKEY, and RRSIG records to ensure cryptographic security.",
    keywords: ["dnssec validator", "chain of trust", "ds record", "dns security", "dnskey", "rrsig check", "dns signatures"],
};

export default function DNSSECPage() {
    return <DNSSECClient />;
}
