import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

import { Plus_Jakarta_Sans, JetBrains_Mono } from "next/font/google";
import SmoothScroll from "@/components/ui/SmoothScroll";
import { Navbar } from "@/components/layout/Navbar";
import { Footer } from "@/components/layout/Footer";

const plusJakarta = Plus_Jakarta_Sans({
  variable: "--font-jakarta",
  subsets: ["latin"],
});

const jetbrainsMono = JetBrains_Mono({
  variable: "--font-jetbrains",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  metadataBase: new URL("https://dnstool.com"),
  title: {
    default: "DNS Tool - Enterprise Network Diagnostics",
    template: "%s | DNS Tool"
  },
  description: "Professional-grade DNS lookup, propagation check, email health, and network security tools for developers and sysadmins.",
  keywords: ["DNS Lookup", "Propagation Checker", "SPF Validator", "DKIM Tester", "Network Tools", "Email Health", "Port Scanner", "SSL Checker"],
  authors: [{ name: "DNS Tool Team" }],
  creator: "DNS Tool",
  openGraph: {
    type: "website",
    locale: "en_US",
    url: "https://dnstool.com",
    title: "DNS Tool - All-in-One Network Utilities",
    description: "Analyze, debug, and monitor your network infrastructure with our suite of free professional tools.",
    siteName: "DNS Tool",
    images: [{
      url: "/opengraph-image.png",
      width: 1200,
      height: 630,
      alt: "DNS Tool - Network Diagnostics & SEO Utilities"
    }]
  },
  twitter: {
    card: "summary_large_image",
    title: "DNS Tool - Enterprise Network Diagnostics",
    description: "The ultimate toolkit for DNS, Email, and Network analysis.",
    creator: "@dnstool",
    images: ["/opengraph-image.png"]
  },
  icons: {
    icon: "/favicon.ico",
  }
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en" suppressHydrationWarning>
      <body
        className={`${geistSans.variable} ${geistMono.variable} ${plusJakarta.variable} ${jetbrainsMono.variable} antialiased font-sans`}
      >
        <SmoothScroll />
        <Navbar />
        {children}
        <Footer />
      </body>
    </html>
  );
}
