"use client";

import React, { useState } from "react";
import { motion, AnimatePresence } from "framer-motion";
import { Plus, Minus, HelpCircle } from "lucide-react";

const faqs = [
    {
        question: "Is DNS Tool completely free to use?",
        answer: "Yes! Currently, all our tools including the advanced Analyzer, DNS Propagation checks, and Blacklist monitors are 100% free for both personal and commercial use. We plan to keep the core features free forever."
    },
    {
        question: "How accurate is the propagation data?",
        answer: "We query 25+ independent DNS resolvers located in distinct data centers across the globe (USA, Europe, Asia, Australia, and South America). This gives you a true real-time picture of your domain's propagation status."
    },
    {
        question: "Do you store my search history?",
        answer: "No. We prioritize privacy. Your search queries are processed in real-time and we do not log or store your domain analysis history on our servers. The 'Recent Searches' you see are stored locally in your own browser."
    },
    {
        question: "Can I use your API for my project?",
        answer: "We are currently in the beta phase of our public API. It allows programmatic access to all the data you see on the dashboard. Check the 'Developer API' section in the future or contact us for early access."
    },
    {
        question: "What does the 'Super Tool' analyzer do?",
        answer: "The Analyst is our flagship tool. It runs parallel checks for WHOIS ownership, DNS records, SSL validity, and Blacklist status simultaneously, giving you a comprehensive health report in under 3 seconds."
    }
];

export const FAQ = () => {
    return (
        <section className="py-24 bg-white border-t border-slate-100">
            <div className="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center mb-16">
                    <div className="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-slate-100 text-slate-600 text-sm font-bold uppercase tracking-wider mb-4 border border-slate-200">
                        <HelpCircle className="w-4 h-4" />
                        Common Questions
                    </div>
                    <h2 className="text-4xl font-black text-slate-900 font-jakarta tracking-tight">
                        Frequently Asked <span className="text-blue-600">Questions</span>
                    </h2>
                </div>

                <div className="space-y-4">
                    {faqs.map((faq, index) => (
                        <FAQItem key={index} faq={faq} />
                    ))}
                </div>

                <div className="mt-16 text-center bg-slate-50 rounded-3xl p-8 border border-slate-100">
                    <h3 className="text-lg font-bold text-slate-900 mb-2">Still have questions?</h3>
                    <p className="text-slate-500 mb-6">We're here to help you debug your network issues.</p>
                    <button className="px-6 py-3 bg-white border border-slate-200 text-slate-700 font-bold rounded-xl hover:bg-slate-50 hover:border-slate-300 transition-all shadow-sm">
                        Contact Support
                    </button>
                </div>
            </div>
        </section>
    );
};

const FAQItem = ({ faq }: { faq: any }) => {
    const [isOpen, setIsOpen] = useState(false);

    return (
        <motion.div
            initial={false}
            className={`border rounded-2xl overflow-hidden transition-colors duration-300 ${isOpen ? 'bg-slate-50 border-blue-200' : 'bg-white border-slate-200 hover:border-slate-300'}`}
        >
            <button
                onClick={() => setIsOpen(!isOpen)}
                className="w-full flex items-center justify-between p-6 text-left"
            >
                <span className={`text-lg font-bold transition-colors ${isOpen ? 'text-blue-700' : 'text-slate-900'}`}>
                    {faq.question}
                </span>
                <span className={`p-2 rounded-full transition-colors ${isOpen ? 'bg-blue-100 text-blue-600' : 'bg-slate-100 text-slate-500'}`}>
                    {isOpen ? <Minus className="w-4 h-4" /> : <Plus className="w-4 h-4" />}
                </span>
            </button>
            <AnimatePresence initial={false}>
                {isOpen && (
                    <motion.div
                        initial={{ height: 0, opacity: 0 }}
                        animate={{ height: "auto", opacity: 1 }}
                        exit={{ height: 0, opacity: 0 }}
                        transition={{ duration: 0.3, ease: "easeInOut" }}
                    >
                        <div className="px-6 pb-6 pt-0 text-slate-600 leading-relaxed font-medium">
                            {faq.answer}
                        </div>
                    </motion.div>
                )}
            </AnimatePresence>
        </motion.div>
    );
};
