"use client";

import React from "react";
import { motion } from "framer-motion";
import { Shield, Zap, Terminal, Globe, Code, Lock, Server } from "lucide-react";

export const Features = () => {
    return (
        <section className="py-32 bg-slate-50 relative overflow-hidden">
            {/* Background Decoration */}
            <div className="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
                <div className="absolute -top-[20%] -right-[10%] w-[600px] h-[600px] bg-blue-100/50 rounded-full blur-3xl opacity-60" />
                <div className="absolute -bottom-[20%] -left-[10%] w-[500px] h-[500px] bg-purple-100/50 rounded-full blur-3xl opacity-60" />
            </div>

            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
                <div className="mb-20">
                    <span className="text-blue-600 font-bold tracking-wider uppercase text-sm bg-blue-50 px-3 py-1 rounded-full border border-blue-100">
                        Why Choose Us
                    </span>
                    <h2 className="text-4xl md:text-5xl font-black text-slate-900 mt-6 font-jakarta tracking-tight leading-tight">
                        Built for <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-indigo-600">Performance</span>. <br />
                        Designed for <span className="text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-pink-600">Developers</span>.
                    </h2>
                </div>

                <div className="grid grid-cols-1 lg:grid-cols-3 gap-6 auto-rows-[minmax(300px,auto)]">
                    {/* Feature 1: Developer API (Large Span) */}
                    <div className="lg:col-span-2 group relative overflow-hidden rounded-[2.5rem] bg-white border border-slate-200 p-8 md:p-12 transition-shadow hover:shadow-2xl hover:shadow-blue-500/5">
                        <div className="relative z-10 flex flex-col h-full">
                            <div className="w-12 h-12 bg-blue-50 rounded-2xl flex items-center justify-center mb-6 text-blue-600 group-hover:scale-110 transition-transform">
                                <Terminal className="w-6 h-6" />
                            </div>
                            <h3 className="text-2xl font-bold text-slate-900 mb-4 font-jakarta">Developer-First API</h3>
                            <p className="text-slate-500 text-lg mb-8 max-w-md">
                                Integrate our powerful DNS and WHOIS data directly into your applications. Full JSON responses with zero caching delay.
                            </p>

                            {/* Code Snippet Simulation */}
                            <div className="mt-auto relative rounded-xl bg-[#1E293B] p-5 font-mono text-sm shadow-xl transform group-hover:translate-y-[-5px] transition-transform duration-500 overflow-x-auto max-w-full">
                                <div className="flex gap-2 mb-4">
                                    <div className="w-3 h-3 rounded-full bg-red-500" />
                                    <div className="w-3 h-3 rounded-full bg-yellow-500" />
                                    <div className="w-3 h-3 rounded-full bg-green-500" />
                                </div>
                                <div className="text-slate-300 whitespace-nowrap">
                                    <span className="text-purple-400">curl</span> -X GET \<br />
                                    &nbsp;&nbsp;<span className="text-green-400">"https://api.dnstool.com/v1/lookup?domain=google.com"</span> \<br />
                                    &nbsp;&nbsp;-H <span className="text-yellow-300">"Authorization: Bearer YOUR_KEY"</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* Feature 2: Global Edge Network */}
                    <div className="lg:col-span-1 group relative overflow-hidden rounded-[2.5rem] bg-[#0F172A] border border-slate-800 p-8 text-white transition-shadow hover:shadow-2xl hover:shadow-purple-500/20">
                        {/* World Map Background Simulation */}
                        <div className="absolute inset-0 opacity-20">
                            <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[140%] h-[140%] bg-[radial-gradient(circle_at_center,_var(--tw-gradient-stops))] from-blue-500/40 to-transparent animate-pulse" />
                        </div>

                        <div className="relative z-10 flex flex-col h-full">
                            <div className="w-12 h-12 bg-slate-800/50 rounded-2xl flex items-center justify-center mb-6 text-blue-400 border border-slate-700">
                                <Globe className="w-6 h-6" />
                            </div>
                            <h3 className="text-2xl font-bold mb-4 font-jakarta">Global Edge Network</h3>
                            <p className="text-slate-400 mb-8">
                                Checks performed from <span className="text-white font-bold">25+ locations</span> worldwide to ensure accurate propagation data.
                            </p>

                            {/* Animated Dots */}
                            <div className="mt-auto grid grid-cols-4 gap-2">
                                {[...Array(12)].map((_, i) => (
                                    <motion.div
                                        key={i}
                                        initial={{ opacity: 0.2 }}
                                        animate={{ opacity: [0.2, 1, 0.2] }}
                                        transition={{
                                            duration: 2,
                                            repeat: Infinity,
                                            delay: Math.random() * 2
                                        }}
                                        className="h-1.5 w-full rounded-full bg-blue-500"
                                    />
                                ))}
                            </div>
                        </div>
                    </div>

                    {/* Feature 3: Privacy & Security */}
                    <div className="lg:col-span-1 group relative overflow-hidden rounded-[2.5rem] bg-white border border-slate-200 p-8 transition-shadow hover:shadow-2xl hover:shadow-green-500/5">
                        <div className="relative z-10 flex flex-col h-full">
                            <div className="w-12 h-12 bg-green-50 rounded-2xl flex items-center justify-center mb-6 text-green-600 group-hover:scale-110 transition-transform">
                                <Lock className="w-6 h-6" />
                            </div>
                            <h3 className="text-2xl font-bold text-slate-900 mb-4 font-jakarta">Usage Privacy</h3>
                            <p className="text-slate-500">
                                We don't track your searches or sell your data. Your diagnostic history is stored locally in your browser.
                            </p>
                        </div>
                    </div>

                    {/* Feature 4: Open Source / Stack */}
                    <div className="lg:col-span-2 group relative overflow-hidden rounded-[2.5rem] bg-gradient-to-br from-blue-600 to-indigo-700 p-8 md:p-12 text-white shadow-lg transition-transform hover:scale-[1.01]">
                        <div className="relative z-10 flex flex-col md:flex-row items-start md:items-center justify-between gap-6 h-full">
                            <div className="max-w-md">
                                <div className="w-12 h-12 bg-white/10 backdrop-blur-sm rounded-2xl flex items-center justify-center mb-6 border border-white/20">
                                    <Zap className="w-6 h-6 text-yellow-300" />
                                </div>
                                <h3 className="text-2xl font-bold mb-4 font-jakarta">Bolt-Fast Performance</h3>
                                <p className="text-blue-100 text-lg">
                                    Powered by Next.js 15 and edge runtime. Experience sub-millisecond route transitions and instant data fetching.
                                </p>
                            </div>

                            {/* Stats */}
                            <div className="flex flex-col gap-4 min-w-[150px]">
                                <div className="bg-white/10 backdrop-blur-md rounded-2xl p-4 border border-white/10">
                                    <div className="text-3xl font-black">99.9%</div>
                                    <div className="text-xs uppercase tracking-wider opacity-80">Uptime</div>
                                </div>
                                <div className="bg-white/10 backdrop-blur-md rounded-2xl p-4 border border-white/10">
                                    <div className="text-3xl font-black">&lt; 100ms</div>
                                    <div className="text-xs uppercase tracking-wider opacity-80">Latency</div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
    );
};
