"use client";

import React, { useEffect, useState } from "react";
import { motion } from "framer-motion";

export const SystemStatus = () => {
    const [latency, setLatency] = useState<number[]>(new Array(20).fill(20));
    const [requests, setRequests] = useState(1243502);

    useEffect(() => {
        const interval = setInterval(() => {
            setLatency(prev => {
                const newLatency = [...prev.slice(1), 20 + Math.random() * 30]; // Simulate 20-50ms
                return newLatency;
            });
            setRequests(prev => prev + Math.floor(Math.random() * 15));
        }, 1000);
        return () => clearInterval(interval);
    }, []);

    return (
        <div className="bg-slate-900/80 backdrop-blur-md border border-slate-700 rounded-xl p-4 w-full max-w-sm font-mono text-xs shadow-2xl">
            <div className="flex justify-between items-center mb-4 pb-2 border-b border-slate-800">
                <div className="flex items-center gap-2">
                    <div className="w-2 h-2 rounded-full bg-green-500 animate-pulse" />
                    <span className="text-slate-400 font-bold uppercase tracking-wider">System Status</span>
                </div>
                <span className="text-green-400">OPERATIONAL</span>
            </div>

            <div className="space-y-4">
                {/* Metric 1: Request Counter */}
                <div className="flex justify-between">
                    <span className="text-slate-500">24h Requests</span>
                    <span className="text-white font-bold">{requests.toLocaleString()}</span>
                </div>

                {/* Metric 2: Uptime */}
                <div className="flex justify-between">
                    <span className="text-slate-500">Uptime</span>
                    <span className="text-green-400 font-bold">99.99%</span>
                </div>

                {/* Metric 3: Latency Visualization */}
                <div>
                    <div className="flex justify-between mb-1">
                        <span className="text-slate-500">Global Latency</span>
                        <span className="text-blue-400 font-bold">{Math.round(latency[latency.length - 1])}ms</span>
                    </div>
                    <div className="h-10 flex items-end gap-[2px]">
                        {latency.map((val, i) => (
                            <motion.div
                                key={i}
                                initial={{ height: 0 }}
                                animate={{ height: `${(val / 60) * 100}%` }}
                                className="flex-1 bg-blue-600/50 rounded-t-sm"
                                style={{
                                    backgroundColor: val > 45 ? '#EF4444' : val > 35 ? '#F59E0B' : '#2563EB'
                                }}
                            />
                        ))}
                    </div>
                </div>

                {/* Terminal Line */}
                <div className="pt-2 border-t border-slate-800 text-slate-600">
                    <span className="text-green-500">root@dns-node:~#</span> check_health --all
                    <br />
                    <span className="opacity-50">Checking edge nodes... OK</span>
                </div>
            </div>
        </div>
    );
};
